#!/usr/bin/python
# Ticker Tape by Tim Howlett October 2014 
# Written in Python (www.python.org) Requires the Pyame module (www.pygame.org)

import sys, pygame, time, math, os
from pygame.locals import *
import urllib.request, urllib.error, urllib.parse, string
import xml.dom.minidom as minidom

# set some constants
BGCOLOR = (0, 0, 0)
WINDOWWIDTH = 1024 # width of the program's window, in pixels
WINDOWHEIGHT = 60 # height in pixels
position = 0, 640
# the below list needs at least 3 entries, they can be the same thing repeated
LIST = ("SkyNews", "BBCNews", "Logo") 
i = 0
j = i+1
k = i+2
ITEM = LIST[i]
ITEM2 = LIST[j]
ITEM3 = LIST[k]
STRAPLINE = "Your Text Here " 
x = 0

# standard pygame setup code
pygame.init()
pygame.mixer.quit() # stops unwanted audio output on some computers
fontObj = pygame.font.SysFont("tahoma", 44)

if sys.platform == 'win32':
    # to make the window be on top
    from ctypes import windll
    SetWindowPos = windll.user32.SetWindowPos
    # Uncomment the line below if you get the error "pygame.error: No available video device"
    os.environ['SDL_VIDEODRIVER']='windib'
    SetWindowPos(pygame.display.get_wm_info()['window'], -1, position[0], position[1], 0, 0, 0x0001)
else:
    os.environ['SDL_VIDEO_WINDOW_POS'] = str(position[0]) + "," + str(position[1])
    
DISPLAYSURF = pygame.display.set_mode((WINDOWWIDTH, WINDOWHEIGHT), pygame.NOFRAME)

SkyLogo = pygame.image.load('SkyNewsLogo.png')
SkyLogo = SkyLogo.convert_alpha()
SkyLogo, SkyLogo.get_rect()

BBCLogo = pygame.image.load('BBCNewsLogo.png')
BBCLogo = BBCLogo.convert_alpha()
BBCLogo = pygame.transform.scale(BBCLogo, (80, 60))
BBCLogo, BBCLogo.get_rect()

TwitterLogo = pygame.image.load('twitter-bird.png')
TwitterLogo = TwitterLogo.convert_alpha()
TwitterLogo = pygame.transform.scale(TwitterLogo, (75, 60))
TwitterLogo, TwitterLogo.get_rect()
strapline = fontObj.render(STRAPLINE, 1, (0, 172, 237))
  
def GetNews():
    global newstime
    global SkyText
    global BBCText
    newstime = time.localtime()
    try:
        url = urllib.request.urlopen('http://feeds.skynews.com/feeds/rss/home.xml')
        news = minidom.parse(url)
        newslist = news.getElementsByTagName('title')
    except:
        newslist = [""]
    text = ""
    for i in range (2, 5):
        try:
            text = text + (newslist[i].childNodes[0].nodeValue + " | ")
        except:
            text = text + "Error reaching URL | "
    SkyText = fontObj.render(text, 1, (255, 255, 255))
    
    try:
        url = urllib.request.urlopen('http://feeds.bbci.co.uk/news/uk/rss.xml')
        news = minidom.parse(url)
        BBCnewslist = news.getElementsByTagName('title')
    except:
        BBCnewslist = [""]
    text = ""
    for i in range (2, 5):
        try:
            text = text + (BBCnewslist[i].childNodes[0].nodeValue + " | ")
        except:
            text = text + "Error reaching URL | "
    BBCText = fontObj.render(text, 1, (255, 64, 64))
    
GetNews()

def SkyNews():
    global w
    global SkyText
    DISPLAYSURF.blit(SkyLogo, (x + w, 5))
    w = w + 10 + SkyLogo.get_rect().width
    textpos = SkyText.get_rect()
    DISPLAYSURF.blit(SkyText, (x + w, 0))
    w = w + 10 + SkyText.get_rect(). width

def BBCNews():
    global w
    global BBCText
    DISPLAYSURF.blit(BBCLogo, (x + 10+ w, 0))
    w = w + 20 + BBCLogo.get_rect().width
    textpos = BBCText.get_rect()
    DISPLAYSURF.blit(BBCText, (x + w, 0))
    w = w + 10 + BBCText.get_rect(). width

def Logo():
    global w
    DISPLAYSURF.blit(TwitterLogo, (x + w, 0))
    w = w + 10 + TwitterLogo.get_rect().width
    textpos = strapline.get_rect()
    DISPLAYSURF.blit(strapline, (x + w, 0))
    w = w + strapline.get_rect(). width
    
while True: # main application loop
    
    # event handling loop for quit events
    for event in pygame.event.get():
        if event.type == QUIT or (event.type == KEYUP and event.key == K_ESCAPE):
            pygame.quit()
            sys.exit()

    # fill the screen to draw from a blank state and draw the clock face
    DISPLAYSURF.fill(BGCOLOR)

    w = 0
    # Call the items
    locals()[ITEM]()
    # If ITEM is out of view increment items
    if x <= - w:
        x = 0
        i = i + 1
        if i >= len(LIST): i = 0
        ITEM = LIST[i]
        j = j + 1
        if j >= len(LIST): j = 0
        ITEM2 = LIST[j]
        k = k + 1
        if k >= len(LIST): k = 0
        ITEM3 = LIST[k]
        locals()[ITEM]()
    # If ITEM doesn't fill the window call ITEM2
    if x <= WINDOWWIDTH - w:
        locals()[ITEM2]()
    # If ITEM and ITEM2 don't fill the window call ITEM3
    if x <= WINDOWWIDTH - w:
        locals()[ITEM3]()
        
    # get the current time
    now = time.localtime()
    now_hour = now[3]
    now_minute = now[4]
    now_second = now[5]
    
    # Write the time - adding 0 before values below 10
    pygame.draw.rect(DISPLAYSURF, (99,179,46), ((WINDOWWIDTH-200), 0, 200, WINDOWHEIGHT))
    # First work out the width with seconds as 00
    if now_second <= 9 and now_minute <= 9:
        text = fontObj.render(str(now_hour) + ":0" + str(now_minute) + ":00", 1, (0,0,0))
    elif now_second <= 9 and now_minute >= 10:
        text = fontObj.render(str(now_hour) + ":" + str(now_minute) + ":00", 1, (0,0,0))  
    elif now_second >= 10 and now_minute <= 9:
        text = fontObj.render(str(now_hour) + ":0" + str(now_minute) + ":00", 1, (0,0,0))  
    else:
        text = fontObj.render(str(now_hour) + ":" + str(now_minute) + ":00", 1, (0,0,0))
    textpos = text.get_rect()
    textpos.centerx = WINDOWWIDTH - 100 #DISPLAYSURF.get_rect(). centerx
    textpos.centery = DISPLAYSURF.get_rect(). centery
    # Now write the time properly
    if now_second <= 9 and now_minute <= 9:
        text = fontObj.render(str(now_hour) + ":0" + str(now_minute) + ":0" + str(now_second), 1, (255,255,255))
    elif now_second <= 9 and now_minute >= 10:
        text = fontObj.render(str(now_hour) + ":" + str(now_minute) + ":0" + str(now_second), 1, (255,255,255))  
    elif now_second >= 10 and now_minute <= 9:
        text = fontObj.render(str(now_hour) + ":0" + str(now_minute) + ":" + str(now_second), 1, (255,255,255))  
    else:
        text = fontObj.render(str(now_hour) + ":" + str(now_minute) + ":" + str(now_second), 1, (255,255,255))
    DISPLAYSURF.blit(text, textpos)
    
    # Put a line at the top and bottom
    pygame.draw.line(DISPLAYSURF, (99,179,46), (0,0), (WINDOWWIDTH,0))
    pygame.draw.line(DISPLAYSURF, (99,179,46), (0,WINDOWHEIGHT-1), (WINDOWWIDTH,WINDOWHEIGHT-1))

    pygame.display.update()       
    pygame.time.wait(10)
    
    # Move starting point left
    x = x-1

    # Update News Every 10 minutes
    if now_second == 0 and now_minute % 10 == 0:
        if newstime[3] != now_hour or newstime[4] != now_minute:
            GetNews()
